% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_netlogo_list.R
\name{parse_netlogo_list}
\alias{parse_netlogo_list}
\title{Parse NetLogo lists}
\usage{
parse_netlogo_list(x)
}
\arguments{
\item{x}{An \code{\link[checkmate:checkAtomic]{atomic}} vector potentially
containing NetLogo-style lists.}
}
\value{
A \code{\link[base:list]{list}} where each element is the parsed result of
the corresponding input element. Parsed elements may be atomic vectors (for
homogeneous lists) or nested lists (for mixed-type or nested lists). If a
NetLogo list is not detected in an input element, that element is returned
as a single-element \code{\link[base:list]{list}} containing the original string.
}
\description{
\code{parse_netlogo_list()} parses NetLogo-style lists represented as strings
(e.g., \code{"[1 2 3]"}) into R lists. It automatically detects
\code{\link[base:numeric]{numeric}}, \code{\link[base:integer]{integer}},
\code{\link[base:logical]{logical}}, and \code{\link[base:character]{character}} types
within the lists and converts them accordingly.

\strong{Note}: We recommend using this function \strong{only when necessary}, as it can
be computationally intensive for large datasets and may not handle all edge
cases. NetLogo provides a special output format called
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{lists}
that exports list metrics in a tabular structure. If your experiment includes
metrics that return NetLogo lists, include \code{"lists"} in the \code{outputs}
argument of \code{\link[=run_experiment]{run_experiment()}} to capture this output.
}
\details{
The function handles the following cases:
\itemize{
\item \strong{Homogeneous lists}: Lists containing elements of the same type are
returned as atomic vectors (e.g., \code{"[1 2 3]"} becomes \code{c(1L, 2L, 3L)}).
\item \strong{Mixed-type lists}: Lists containing elements of different types are
returned as R lists (e.g., \code{'[1.1 "a" true]'} becomes
\code{list(1.1, "a", TRUE)}).
\item \strong{Nested lists}: Lists containing other lists are fused with the main
list (e.g., \code{'["a" "b" [1 2]]'} becomes
\code{list(c("a", "b"), c(1L, 2L))}).
}

NetLogo boolean values (\code{true}/\code{false}) are converted to R
\code{\link[base:logical]{logical}} values (\code{TRUE}/\code{FALSE}). NetLogo
\code{NaN} values are parsed as R \code{\link[base:is.finite]{NaN}} .
}
\examples{
# Scalar Examples -----

'test' |> parse_netlogo_list() # Not a NetLogo list.

'[1]' |> parse_netlogo_list()

'["a" "b" "c"]' |> parse_netlogo_list()

'[1 2 3]' |> parse_netlogo_list()

'[1.1 2.1 3.1]' |> parse_netlogo_list()

'[true false true]' |> parse_netlogo_list()

# Vector Examples -----

c(1, 2, 3) |> parse_netlogo_list() # Not a NetLogo list.

c('["a" "b" "c"]', '["d" "e" "f"]') |> parse_netlogo_list()

c('[1 2 3]', '[4 5 6]') |> parse_netlogo_list()

c('[1.1 2.1 3.1]', '[4.1 5.1 6.1]') |> parse_netlogo_list()

c('[true false true]', '[false true false]') |> parse_netlogo_list()

# Mixed-Type Examples -----

'["a" "b" 1 2]' |> parse_netlogo_list()

'[1.1 2.1 3.1 true false]' |> parse_netlogo_list()

'[1.1 "a" true]' |> parse_netlogo_list()

# Nested Examples -----

'["a" "b" "c" [1 2]]' |> parse_netlogo_list()

'["a" "b" "c" [1 2] true ["d" "c"]]' |> parse_netlogo_list()

'[[1 2] [3 4] [5 6]]' |> parse_netlogo_list()
}
\seealso{
Other parsing functions: 
\code{\link{parse_netlogo_color}()}
}
\concept{parsing functions}
