% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_netlogo_version.R
\name{find_netlogo_version}
\alias{find_netlogo_version}
\title{Find NetLogo version}
\usage{
find_netlogo_version()
}
\value{
A \code{\link[base:character]{character}} string specifying the NetLogo
version (e.g., \code{"7.0.3"}). Returns \code{\link[base:NA]{NA}} if the version
cannot be determined.
}
\description{
\code{find_netlogo_version()} attempts to determine the NetLogo version installed
on the user's system.
}
\details{
The function uses the following detection methods in order:
\enumerate{
\item If the NetLogo console executable is found by
\code{\link[=find_netlogo_console]{find_netlogo_console()}}, it runs
\code{NetLogo_Console --headless --version} command to retrieve the
version information. This is the most reliable method.
\item If the executable is not found, it attempts to extract the version number
from the installation directory name returned by
\code{\link[=find_netlogo_home]{find_netlogo_home()}} (e.g., \verb{NetLogo 7.0.2} yields
\code{"7.0.2"}). Note that this fallback may produce slightly different results
if the directory was renamed or uses a non-standard naming convention.
}
}
\examples{
\dontrun{
  find_netlogo_version()
}
}
\seealso{
Other system functions: 
\code{\link{find_netlogo_console}()},
\code{\link{find_netlogo_home}()}
}
\concept{system functions}
