% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_netlogo_console.R
\name{find_netlogo_console}
\alias{find_netlogo_console}
\title{Find NetLogo executable file}
\usage{
find_netlogo_console()
}
\value{
A \code{\link[base:character]{character}} string specifying the path to the
NetLogo executable file. Returns \code{\link[base:NA]{NA}} if the executable
cannot be found at any location.
}
\description{
\code{find_netlogo_console()} attempts to locate the NetLogo executable file on
the user's system.
}
\details{
The function uses the following search order:
\enumerate{
\item Checks the \code{NETLOGO_CONSOLE} environment variable. If set and the file
exists, returns that path.
\item If the environment variable is not set or the file does not exist,
constructs and expands the path based on the output of
\code{\link[=find_netlogo_home]{find_netlogo_home()}}
(\verb{<NETLOGO_HOME>/NetLogo_Console.exe} on Windows or
\verb{<NETLOGO_HOME>/NetLogo_Console} for other systems).
}
}
\examples{
\dontrun{
  find_netlogo_console()
}
}
\seealso{
Other system functions: 
\code{\link{find_netlogo_home}()},
\code{\link{find_netlogo_version}()}
}
\concept{system functions}
