% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{extract_r_code}
\alias{extract_r_code}
\title{Extract R code from a string}
\usage{
extract_r_code(input_string)
}
\arguments{
\item{input_string}{A string containing R code blocks, typically a response
from an LLM}
}
\value{
A character vector containing the extracted R code
}
\description{
This function extracts R code from a string by matching all content between
'```r' or '```R' and '```'.
}
\examples{
# Simple example
text <- "Here is some R code:\n```r\nprint('Hello')\n```"
extract_r_code(text)

# Multiple code blocks
response <- "
First block:
```r
x <- 1:10
mean(x)
```

Second block:
```R
library(ggplot2)
ggplot(mtcars, aes(mpg, hp)) + geom_point()
```
"
codes <- extract_r_code(response)
length(codes) # Returns 2

# With surrounding text
llm_response <- "
To calculate the mean, use this code:
```r
data <- c(1, 2, 3, 4, 5)
result <- mean(data)
print(result)
```
The result will be 3.
"
extract_r_code(llm_response)

}
