# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# atropellados_pts


library(testthat)

test_that("atropellados_pts is a data.frame", {
  expect_s3_class(atropellados_pts, "data.frame")
})

# Test 2: Confirm it has exactly 8 columns
test_that("atropellados_pts has 8 columns", {
  expect_equal(length(atropellados_pts), 8)
})

# Test 3: Confirm it has exactly 1841 rows
test_that("atropellados_pts has 1841 rows", {
  expect_equal(nrow(atropellados_pts), 1841)
})

# Test 4: Confirm column names are correct
test_that("atropellados_pts has correct column names", {
  expect_named(atropellados_pts, c(
    "X", "Y", "Ubicacion", "Fallecidos",
    "Graves", "MenosGrave", "Leve", "Accidentes"
  ))
})

# Test 5: Confirm column types are as expected
test_that("atropellados_pts columns have correct types", {
  expect_type(atropellados_pts$X, "double")
  expect_type(atropellados_pts$Y, "double")
  expect_type(atropellados_pts$Ubicacion, "character")
  expect_type(atropellados_pts$Fallecidos, "integer")
  expect_type(atropellados_pts$Graves, "integer")
  expect_type(atropellados_pts$MenosGrave, "integer")
  expect_type(atropellados_pts$Leve, "integer")
  expect_type(atropellados_pts$Accidentes, "integer")
})
