% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{compute_GhalfXy_temp_wrapper}
\alias{compute_GhalfXy_temp_wrapper}
\title{Compute Component \eqn{\textbf{G}^{1/2}\textbf{A}(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}}}
\usage{
compute_GhalfXy_temp_wrapper(
  G,
  Ghalf,
  A,
  AGAInv,
  Xy,
  nc,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{G}{List of \eqn{\textbf{G}} matrices}

\item{Ghalf}{List of \eqn{\textbf{G}^{1/2}} matrices}

\item{A}{Constraint matrix \eqn{\textbf{A}}}

\item{AGAInv}{Inverse of \eqn{\textbf{A}^{T}\textbf{G}\textbf{A}}}

\item{Xy}{List of \eqn{\textbf{X}^{T}\textbf{y}} products}

\item{nc}{Number of columns}

\item{K}{Number of partitions minus 1 (\eqn{K})}

\item{parallel}{Use parallel processing}

\item{cl}{Cluster object}

\item{chunk_size}{Size of parallel chunks}

\item{num_chunks}{Number of chunks}

\item{rem_chunks}{Remaining chunks}
}
\value{
List containing:
\itemize{
  \item Result vector
  \item AGAInvAGXy intermediate product \eqn{(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}}
}
}
\description{
Compute Component \eqn{\textbf{G}^{1/2}\textbf{A}(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}}
}
\details{
Computes \eqn{\textbf{G}^{1/2}\textbf{A}(\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}} efficiently in parallel chunks.
Note: The description seems slightly off from the C++ helper functions called (e.g., `compute_AGXy`, `compute_result_blocks`). This computes a component needed for least-squares transformation involving \eqn{\textbf{G}^{1/2}}.
Returns both the result and intermediate \eqn{\textbf{A}^{T}\textbf{G}\textbf{A})^{-1}\textbf{A}^{T}\textbf{G}\textbf{X}^{T}\textbf{y}} product for reuse.
}
\keyword{internal}
