% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lingexpr.R
\docType{data}
\name{lingexpr}
\alias{lingexpr}
\alias{allowed.lingexpr}
\title{Creator of functions representing linguistic expressions}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 9 rows and 11 columns.
}
\usage{
lingexpr(
  context,
  atomic = c("sm", "me", "bi", "lm", "um", "ze", "neg.sm", "neg.me", "neg.bi", "neg.lm",
    "neg.um"),
  hedge = c("ex", "si", "ve", "ty", "-", "ml", "ro", "qr", "vr"),
  negated = FALSE,
  hedgeParams = defaultHedgeParams
)

allowed.lingexpr
}
\arguments{
\item{context}{A context of linguistic expressions (see \code{\link[=ctx3]{ctx3()}}, \code{\link[=ctx5]{ctx5()}}, \code{\link[=ctx3bilat]{ctx3bilat()}} or \code{\link[=ctx5bilat]{ctx5bilat()}})}

\item{atomic}{An atomic expression whose horizon we would like to obtain}

\item{hedge}{The type of the required linguistic hedge ('-' for no hedging)}

\item{negated}{Negate the expression? (For instance, "not very small".) Negation
is done using the \code{\link[=invol.neg]{invol.neg()}} function.}

\item{hedgeParams}{Parameters that determine the shape of the hedges}
}
\value{
Returns a function with a single argument, which has to be a numeric vector.
}
\description{
A linguistic expression represents vague human terms such as "very small", "extremely big" etc. Such notions are
always reasoned within a given context. \code{lingexpr} returns a function that models a selected linguistic expression.
Accordingly to the given \code{context}, \code{atomic} expression (such as "small", "big") and a linguistic \code{hedge} (such as
\code{very}, \code{extremely}), the returned function transforms numeric values into degrees (from \verb{[0, 1]} interval),
at which the values correspond to the expression.
}
\details{
Based on the context type, the following atomic expressions are allowed:
\itemize{
\item \code{\link[=ctx3]{ctx3()}} (trichotomy): small, medium, big;
\item \code{\link[=ctx5]{ctx5()}} (pentachotomy): small, lower medium, medium, upper medium, big;
\item \code{\link[=ctx3bilat]{ctx3bilat()}} (bilateral trichotomy): negative big, negative medium, negative small,
zero, small, medium, big;
\item \code{\link[=ctx5bilat]{ctx5bilat()}} (bilateral pentachotomy): negative big, negative medium, negative
small, zero, small, medium, big.
}

The values of the \code{atomic} parameter have the following meaning (in ascending order):
\itemize{
\item \code{neg.bi}: big negative (far from zero)
\item \code{neg.um}: upper medium negative (between medium negative and big negative)
\item \code{neg.me}: medium negative
\item \code{neg.lm}: lower medium negative (between medium negative and small negative)
\item \code{neg.sm}: small negative (close to zero)
\item \code{ze}: zero
\item \code{sm}: small
\item \code{lm}: lower medium
\item \code{me}: medium
\item \code{um}: upper medium
\item \code{bi}: big
}

\code{hedge} parameter has the following meaning:
\itemize{
\item \code{ex}: extremely,
\item \code{si}: significantly,
\item \code{ve}: very,
\item \code{ty}: typically,
\item \code{-}: empty hedge,
\item \code{ml}: more or less,
\item \code{ro}: roughly,
\item \code{qr}: quite roughly,
\item \code{vr}: very roughly.
}

Accordingly to the theory of linguistic expressions by Novak, not every hedge is applicable to each atomic
expression. The combinations of allowed pairs can be found in \link{allowed.lingexpr}. Trying to create forbidden
combination results in error.
}
\examples{
    small <- lingexpr(ctx3(0, 0.5, 1), atomic='sm', hedge='-')
    small(0)   # 1
    small(0.8) # 0
    plot(small)

    verySmall <- lingexpr(ctx3(0, 0.5, 1), atomic='sm', hedge='ve')
    plot(verySmall)
}
\seealso{
\code{\link[=horizon]{horizon()}}, \code{\link[=hedge]{hedge()}}, \code{\link[=fcut]{fcut()}}, \code{\link[=lcut]{lcut()}}, \code{\link[=ctx]{ctx()}}
}
\author{
Michal Burda
}
\keyword{datasets}
\keyword{models}
\keyword{robust}
