% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavinteract-package.R
\docType{package}
\name{lavinteract}
\alias{lavinteract}
\alias{lavinteract-package}
\title{Post-Estimation Utilities for 'lavaan' Fitted Models}
\description{
Companion toolbox for structural equation models fitted with 'lavaan'.
Operates directly on a fitted object using its estimates and covariance.
Refits auxiliary models when needed to compute estimates, diagnostics, and plots.
}
\details{
The functions are:
\itemize{
  \item \code{\link{lav_slopes}}: simple slopes and interaction plots from a fitted 'lavaan' model.
  \item \code{\link{lav_vif}}: variance inflation factors for structural predictors with measurement preserved.
  \item \code{\link{lav_cv}}: repeated holdout (Monte Carlo) cross-validation of R^2 for SEM outcomes.
  \item \code{\link{lav_fdr}}: false discovery rate correction for selected 'lavaan' parameter p-values.
}
}
\section{Note}{

The development of this package grew from ongoing discussions and interactions (sic)
with colleagues, in particular Dr. Cataldo Giuliano Gemmano, whose steady 
feedback and support helped shape it.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/g-corbelli/lavinteract}
  \item Report bugs at \url{https://github.com/g-corbelli/lavinteract/issues}
}

}
\author{
Giuseppe Corbelli (<giuseppe.corbelli@uninettunouniversity.net>)
}
\keyword{R2}
\keyword{SEM}
\keyword{diagnostics}
\keyword{interactions}
\keyword{lavaan}
\keyword{moderation}
\keyword{multicollinearity}
\keyword{multipletesting}
\keyword{plotting}
\keyword{validation}
