% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_image_custom.R
\name{llm_image_custom}
\alias{llm_image_custom}
\title{Customized Vision using LLMs}
\usage{
llm_image_custom(
  llm_model = "qwen2.5vl",
  image = system.file("img/test_img.jpg", package = "kuzco"),
  backend = "ellmer",
  system_prompt = "You are a terse assistant in computer vision sentiment.",
  image_prompt = "return JSON describing image, do not include json or backticks",
  example_df = NULL,
  provider = "ollama",
  ...
)
}
\arguments{
\item{llm_model}{a local LLM model either pulled from ollama or hosted}

\item{image}{a local image path that has a jpeg, jpg, or png}

\item{backend}{either 'ollamar' or 'ellmer'}

\item{system_prompt}{overarching assistant description, \emph{please note that the LLM should be told to return as JSON while kuzco will handle the conversions to and from JSON}}

\item{image_prompt}{anything you want to really remind the llm about.}

\item{example_df}{an example data.frame to show the llm what you want returned \emph{note this will be converted to JSON for the LLM}.}

\item{provider}{for \code{backend = 'ollamar'}, \code{provider} is ignored. for \code{backend = 'ellmer'},
\code{provider} refers to the \verb{ellmer::chat_*} providers and can be used to switch
from "ollama" to other providers such as "perplexity"}

\item{...}{a pass through for other generate args and model args like temperature}
}
\value{
a customized return based on example_df for custom control
}
\description{
Customized Vision using LLMs
}
\examples{
\donttest{

llm_image_custom(
 llm_model = "qwen2.5vl",
 image = system.file("img/test_img.jpg", package = "kuzco"),
 backend = "ellmer",
 system_prompt = "You are a terse assistant in computer vision sentiment.",
 image_prompt = "return JSON describing image, do not include json or backticks",
 example_df = NULL,
 provider = "ollama"
)
}
}
