% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_muon}
\alias{optimizer_muon}
\title{Optimizer that implements the Muon algorithm.}
\usage{
optimizer_muon(
  learning_rate = 0.001,
  adam_beta_1 = 0.9,
  adam_beta_2 = 0.999,
  epsilon = 1e-07,
  weight_decay = 0.1,
  clipnorm = NULL,
  clipvalue = NULL,
  global_clipnorm = NULL,
  use_ema = FALSE,
  ema_momentum = 0.99,
  ema_overwrite_frequency = NULL,
  loss_scale_factor = NULL,
  gradient_accumulation_steps = NULL,
  name = "muon",
  exclude_layers = NULL,
  exclude_embeddings = TRUE,
  muon_a = 3.4445,
  muon_b = -4.775,
  muon_c = 2.0315,
  adam_lr_ratio = 0.1,
  momentum = 0.95,
  ns_steps = 6L,
  nesterov = TRUE,
  ...
)
}
\arguments{
\item{learning_rate}{A float,
\code{LearningRateSchedule()} instance, or
a callable that takes no arguments and returns the actual value to
use. The learning rate. Defaults to \code{0.001}.}

\item{adam_beta_1}{A float value or a constant float tensor, or a callable
that takes no arguments and returns the actual value to use.
The exponential decay rate for the 1st moment estimates. Defaults to
\code{0.9}.}

\item{adam_beta_2}{A float value or a constant float tensor, ora callable
that takes no arguments and returns the actual value to use.
The exponential decay rate for the 2nd moment estimates. Defaults to
\code{0.999}.}

\item{epsilon}{A small constant for numerical stability. This is
"epsilon hat" in the Kingma and Ba paper
(in the formula just before Section 2.1),
not the epsilon in Algorithm 1 of the paper.
It is used as in AdamW. Defaults to \code{1e-7}.}

\item{weight_decay}{Float. If set, weight decay is applied.}

\item{clipnorm}{Float. If set, the gradient of each weight is individually
clipped so that its norm is no higher than this value.}

\item{clipvalue}{Float. If set, the gradient of each weight is clipped to be
no higher than this value.}

\item{global_clipnorm}{Float. If set, the gradient of all weights is clipped
so that their global norm is no higher than this value.}

\item{use_ema}{Boolean, defaults to \code{FALSE}.
If \code{TRUE}, exponential moving average (EMA) is applied. EMA consists of
computing an exponential moving average of the weights of the model (as
the weight values change after each training batch), and periodically
overwriting the weights with their moving average.}

\item{ema_momentum}{Float, defaults to \code{0.99}. Only used if \code{use_ema = TRUE}.
This is the momentum to use when computing the EMA of the model's
weights: \code{new_average = ema_momentum * old_average + (1 - ema_momentum) * current_variable_value}.}

\item{ema_overwrite_frequency}{Int or \code{NULL}, defaults to \code{NULL}. Only used if \code{use_ema = TRUE}. Every
\code{ema_overwrite_frequency} steps of iterations, we overwrite the model
variable by its moving average. If \code{NULL}, the optimizer does not overwrite
model variables in the middle of training, and you need to explicitly
overwrite the variables at the end of training by calling
\code{optimizer$finalize_variable_values()} (which updates the model variables
in-place). When using the built-in \code{fit()} training loop, this happens
automatically after the last epoch, and you don't need to do anything.}

\item{loss_scale_factor}{Float or \code{NULL}. If a float, the scale factor will be multiplied the loss
before computing gradients, and the inverse of the scale factor will be
multiplied by the gradients before updating variables. Useful for
preventing underflow during mixed precision training. Alternately,
\code{\link[=optimizer_loss_scale]{optimizer_loss_scale()}} will automatically set a loss scale factor.}

\item{gradient_accumulation_steps}{Int or \code{NULL}. If an int, model and optimizer variables will not be updated
at every step; instead they will be updated every \code{gradient_accumulation_steps}
steps, using the average value of the gradients since the last update. This
is known as "gradient accumulation". This can be useful when your batch size is
very small, in order to reduce gradient noise at each update step. EMA
frequency will look at "accumulated" iterations value (optimizer steps //
gradient_accumulation_steps). Learning rate schedules will look at "real"
iterations value (optimizer steps).}

\item{name}{String, name for the object}

\item{exclude_layers}{List of strings, keywords of layer names to exclude.
All layers with keywords in their path will use AdamW.}

\item{exclude_embeddings}{Boolean value.
If \code{TRUE}, embedding layers will use AdamW.}

\item{muon_a}{Float, parameter a of the muon algorithm.
It is recommended to use the default value.}

\item{muon_b}{Float, parameter b of the muon algorithm.
It is recommended to use the default value.}

\item{muon_c}{Float, parameter c of the muon algorithm.
It is recommended to use the default value.}

\item{adam_lr_ratio}{Float, the ratio of the learning rate when
using Adam to the main learning rate.
it is recommended to set it to \code{0.1}.}

\item{momentum}{Float, momentum used by internal SGD.}

\item{ns_steps}{Integer, number of Newton-Schulz iterations to run.}

\item{nesterov}{Boolean, whether to use Nesterov-style momentum.}

\item{...}{For forward/backward compatibility.}
}
\value{
an \code{Optimizer} instance
}
\description{
Note that this optimizer should not be used in the following layers:
\enumerate{
\item Embedding layer
\item Final output fully connected layer
\item Any 0- or 1-D variables
}

These should all be optimized using AdamW.

The Muon optimizer can use both the Muon update step or the
AdamW update step based on the following:
\itemize{
\item For any variable that isn't 2D, 3D or 4D, the AdamW step
will be used. This is not configurable.
\item If the argument \code{exclude_embeddings} (defaults to \code{TRUE}) is set
to \code{TRUE}, the AdamW step will be used.
\item For any variable with a name that matches an expression
listed in the argument \code{exclude_layers} (a list), the
AdamW step will be used.
\item Any other variable uses the Muon step.
}

Typically, you only need to pass the name of your densely-connected
output layer to \code{exclude_layers}, e.g.
\code{exclude_layers = "output_dense"}.
}
\section{References}{
\itemize{
\item \href{https://github.com/KellerJordan/Muon}{Original implementation}
\item \href{https://arxiv.org/abs/2502.16982}{Liu et al, 2025}
}
}

\seealso{
Other optimizers: \cr
\code{\link{optimizer_adadelta}()} \cr
\code{\link{optimizer_adafactor}()} \cr
\code{\link{optimizer_adagrad}()} \cr
\code{\link{optimizer_adam}()} \cr
\code{\link{optimizer_adam_w}()} \cr
\code{\link{optimizer_adamax}()} \cr
\code{\link{optimizer_ftrl}()} \cr
\code{\link{optimizer_lamb}()} \cr
\code{\link{optimizer_lion}()} \cr
\code{\link{optimizer_loss_scale}()} \cr
\code{\link{optimizer_nadam}()} \cr
\code{\link{optimizer_rmsprop}()} \cr
\code{\link{optimizer_sgd}()} \cr
}
\concept{optimizers}
