% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensemakr.R
\name{summary.iv.sensemakr}
\alias{summary.iv.sensemakr}
\alias{print.summary.iv.sensemakr}
\title{Sensitivity analysis print and summary methods for \code{iv.sensemakr}}
\usage{
\method{summary}{iv.sensemakr}(object, ...)

\method{print}{summary.iv.sensemakr}(x, digits = 3, ...)
}
\arguments{
\item{object}{an object of class \code{\link{sensemakr}}.}

\item{...}{arguments passed to other methods.}

\item{x}{an object of class \code{\link{sensemakr}}.}

\item{digits}{minimal number of \emph{significant} digits.}
}
\value{
\code{summary.iv.sensemakr} returns an object of class \code{summary.iv.sensemakr}.
The \code{print} methods return the object invisibly.
}
\description{
The \code{print} and \code{summary} methods provide verbal descriptions of the sensitivity analysis results
obtained with the function \code{\link{sensemakr}}.
}
\examples{
data("card")
y <- card$lwage
d <- card$educ
z <- card$nearc4
x <- model.matrix( ~ exper + expersq + black + south + smsa + reg661 + reg662 +
                     reg663 + reg664 + reg665+ reg666 + reg667 + reg668 + smsa66,
                   data = card)
card.fit <- iv_fit(y, d, z, x)
card.sens <- sensemakr(card.fit, benchmark_covariates = "black")
print(card.sens)
summary(card.sens)
}
