% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{plot_parametric}
\alias{plot_parametric}
\title{Visualization of group estimates.}
\usage{
plot_parametric(
  x,
  pred,
  cond = list(),
  parametricOnly = FALSE,
  rm.ranef = TRUE,
  col = "black",
  se = 1.96,
  print.summary = getOption("itsadug_print"),
  main = NULL,
  xlab = NULL,
  ...
)
}
\arguments{
\item{x}{A gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}.}

\item{pred}{A named list of the values to use for the predictor terms 
to plot.}

\item{cond}{A named list of the values to use for the other predictor terms 
(not in view). Used for choosing between smooths that share the same view 
predictors.}

\item{parametricOnly}{Logical: whether or not to cancel out all smooth 
terms and only use the predictors in the parametric summary.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE.}

\item{col}{The colors for the lines and the error bars of the plot.}

\item{se}{If less than or equal to zero then only the predicted surface is 
plotted, but if greater than zero, then the predicted values plus 
confidence intervals are plotted. The value of se will be multiplied with 
the standard error (i.e., 1.96 results in 95\%CI and 2.58).}

\item{print.summary}{Logical: whether or not to print summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{main}{Changing the main title for the plot, see also title.}

\item{xlab}{Changing the label for the x axis, 
defaults to a description of x.}

\item{...}{other options to pass on to \code{\link[plotfunctions]{dotplot_error}}, 
see \code{\link[graphics]{par}}}
}
\description{
Plots a smooth from a \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}} model based on predictions.
In contrast with the default \code{\link[mgcv]{plot.gam}}, this function 
plots the summed effects and optionally removes the random effects.
}
\section{Warning}{

Use \code{parametricOnly} with care! When set to TRUE, all smooth 
predictors are set to 0. Note that this might result in strange 
predictions, because a value of 0 does not always represents a realistic 
situation (e.g., body temperature of 0 is highly unlikely).  
Note that linear slopes are not set to zero, because they are 
considered as parametric terms. If \code{cond} does not specify a value for 
these continuous predictors, the closes value to the mean is automatically  
selected.
}

\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group)
    + s(Time, Subject, bs='fs', m=1), data=simdat)
plot_parametric(m1, pred=list(Group=c('Adults', 'Children')))
# Note the summary that is printed.

# use rm.ranef to cancel random effects:
plot_parametric(m1, pred=list(Group=c('Adults', 'Children')),
    rm.ranef = TRUE)

# It is possible to get estimates that do not make sense:
out <- plot_parametric(m1, 
    pred=list(Group=c('Adults', 'Children'), Subject=c('a01', 'a02', 'c01')))
print(out)
}

# see the vignette for examples:
vignette('overview', package='itsadug')
}
\seealso{
\code{\link[mgcv]{plot.gam}}

Other Functions for model inspection: 
\code{\link{dispersion}()},
\code{\link{fvisgam}()},
\code{\link{gamtabs}()},
\code{\link{inspect_random}()},
\code{\link{plot_data}()},
\code{\link{plot_smooth}()},
\code{\link{plot_topo}()},
\code{\link{pvisgam}()}
}
\author{
Jacolien van Rij, based on a function of Fabian Tomaschek
}
\concept{Functions for model inspection}
