% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{istat_timeout}
\alias{istat_timeout}
\title{Get or set the API timeout}
\usage{
istat_timeout(seconds = NULL)
}
\arguments{
\item{seconds}{Optional. If provided, sets the timeout to this value in seconds.
If NULL (default), returns the current timeout value.}
}
\value{
If \code{seconds} is NULL, returns the current timeout value.
If \code{seconds} is provided, invisibly returns the previous timeout value.
}
\description{
The ISTAT API can be slow to respond, especially for large queries.
This function allows you to get or set the timeout value in seconds.
The default timeout is 300 seconds (5 minutes).
}
\examples{
# Get current timeout
istat_timeout()

# Set timeout to 10 minutes
istat_timeout(600)

# Set timeout back to default
istat_timeout(300)
}
