% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_ipea.R
\name{scale_color_ipea}
\alias{scale_color_ipea}
\title{Scale color IPEA}
\usage{
scale_color_ipea(
  palette = c("Blue", "Green", "Orange", "Pink", "Pink-Deep", "Green-Blue",
    "Green-Blue-White", "Red-Blue", "Red-Blue-White", "Orange-Blue", "Orange-Blue-White",
    "Viridis", "Inferno", "Magma", "Plasma", "Cividis"),
  palette_direction = 1,
  decimal.mark = ",",
  barheight = NULL,
  barwidth = NULL,
  title.hjust = NULL,
  label.hjust = NULL,
  ...
)
}
\arguments{
\item{palette}{A character vector specifying the available palette for the
color palette. The default palette are \code{"Blue"}, but we can also change
to \code{'Green'}, \code{'Orange'}, \code{'Pink'}, \code{'Pink-Deep'}, \code{'Red-Blue'}, \code{'Orange-Blue'}, \code{'Green-Blue'},
\code{'Red-Blue-White'}, \code{'Orange-Blue-White'}, \code{'Green-Blue-White'},
\code{'Viridis'}, \code{'Inferno'}, \code{'Magma'}, \code{'Plasma'}, \code{'Cividis'}.}

\item{palette_direction}{A logical argument specifying if the ordering of the colors
will follow the default of the palette (when the argument is 1) or if it will
have an inverted ordering (for cases where it is -1).}

\item{decimal.mark}{The character to be used to indicate the numeric decimal point and
Character used between every 3 digits to separate thousands.
By default, the function uses a comma \code{","}, following
the format used in Brazilian Portuguese.}

\item{barheight}{The height of the color gradient bar. This parameter is used
when the direction is set to "horizontal".}

\item{barwidth}{The width of the color gradient bar. This parameter is used
when the direction is set to "horizontal".}

\item{title.hjust}{A number specifying horizontal justification of the title text.}

\item{label.hjust}{A number specifying vertical justification of the title text.}

\item{...}{Additional arguments to be passed to the scale_fill_gradientn,
scale_color_gradientn, scale_fill_distiller or scale_color_distiller
function from the ggplot2 package.}
}
\value{
A list object be added to a ggplot object to change color pallete.
}
\description{
Generate a color palette (continuous or discrete) following the
editorial guidelines used by the Institute for Applied Economic
Research - Ipea.
}
\examples{
# Creating scale for ggplot2 graph using default arguments
library(ggplot2)
fig_raw <- ggplot() +
  geom_point(data = mtcars, aes(x = hp , y = mpg, color = cyl)) +
  scale_color_ipea()

# Creating scale for ggplot2 graph using green sequential palette
fig_raw <- ggplot() +
  geom_point(data = mtcars, aes(x = hp , y = mpg, color = cyl)) +
  scale_color_ipea(palette = "Green")
}
\seealso{
Other ggplot2 theme functions: 
\code{\link{scale_fill_ipea}()},
\code{\link{theme_ipea}()}
}
\concept{ggplot2 theme functions}
