% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variaveis.R
\name{ibge_variables}
\alias{ibge_variables}
\title{Get variable data from an aggregate}
\usage{
ibge_variables(
  aggregate,
  variable = NULL,
  periods = -6,
  localities = "BR",
  classification = NULL,
  view = NULL,
  validate = TRUE
)
}
\arguments{
\item{aggregate}{Numeric aggregate identifier (SIDRA table).}

\item{variable}{Variable(s) to retrieve. Can be:
\itemize{
\item \code{NULL} (default): returns all standard variables
\item Numeric vector: specific IDs, e.g. \code{c(284, 285)}
\item \code{"all"}: includes automatically generated percentage variables
}}

\item{periods}{Period(s) to query. Can be:
\itemize{
\item Negative integer: last N periods, e.g. \code{-6} (default)
\item Numeric vector: e.g. \code{c(201701, 201702, 201703)}
\item String with range: e.g. \code{"201701-201712"}
}}

\item{localities}{Locality(ies) to query. Can be:
\itemize{
\item \code{"BR"} (default): Brazil
\item Level code: \code{"N3"} (all states), \code{"N6"} (all municipalities)
\item Named list for specific localities:
\code{list(N3 = c(33, 35))} (RJ and SP states),
\code{list(N6 = c(3550308, 3304557))} (SP and RJ municipalities)
}}

\item{classification}{Classification(s) to filter results. Named list
where names are classification IDs and values are category ID vectors.
Use \code{"all"} for all categories.
E.g. \code{list("226" = c(4844, 96608), "218" = 4780)}}

\item{view}{Display mode: \code{NULL} (default), \code{"OLAP"} or \code{"flat"}.}

\item{validate}{Logical. If \code{TRUE} (default), validates parameters against
aggregate metadata before querying. Use \code{FALSE} to skip.}
}
\value{
A \link[tibble:tibble]{tibble} in tidy (long) format with columns:
\code{variable_id}, \code{variable_name}, \code{variable_unit},
classification columns (when present),
\code{locality_id}, \code{locality_name}, \code{locality_level},
\code{period}, \code{value}
}
\description{
Main function of the package. Retrieves variable results from an IBGE
aggregate for the specified localities, periods and classifications.
}
\details{
Before querying the API, validates all parameters against the aggregate
metadata. If any parameter is invalid, stops with a clear error message
showing the allowed values.
}
\examples{
\dontrun{
# IPCA in Brazil
ibge_variables(7060, localities = "BR")

# Specific variables for states
ibge_variables(1705, variable = c(284, 285), localities = "N3")

# Specific municipalities with classification
ibge_variables(
  aggregate      = 1712,
  variable       = 214,
  periods        = -3,
  localities     = list(N6 = c(3550308, 3304557)),
  classification = list("226" = c(4844, 96608))
)
}


}
