% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_measures.R
\name{add_measures}
\alias{add_measures}
\alias{add_measures.data.frame}
\alias{add_measures.hy}
\title{Add aggregate id measures to flowlines}
\usage{
add_measures(x)

\method{add_measures}{data.frame}(x)

\method{add_measures}{hy}(x)
}
\arguments{
\item{x}{sf data.frame compatible with \link{hydroloom_names} with at least
id and aggregate_id attributes. A pre-populated toid attribute will be used
if present.}
}
\value{
x with aggregate measures added to it
}
\description{
given a set of connected flowlines that have ids and aggregate ids, adds
from_aggregate_id_measure and to_aggregate_id_measure for use with
\link{index_points_to_lines}

Aggregate ids, such as mainstem ids or reachcodes span multiple flowlines.
Linear referencing along these features requires knowledge of the portion
of the aggregate line a given flowline makes up. This function assumes
that the complete aggregate feature is included and calculates the measure
of the top and bottom of each flowline along each aggregate line.
}
\details{
If no "toid" attribute is included, \link{make_attribute_topology} is used to
to create one. This is required to ensure the flowlines making up each
aggregate line are sorted in a known upstream to downstream order.

This function assumes that all flowlines that make up an aggregate feature
are included. Returned measures will be incomplete and incorrect if aggregate
features (mainstems of reaches) are truncated.
}
\examples{
g <- sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom"))

d <- dplyr::select(g, COMID, REACHCODE) |>
  sf::st_cast("LINESTRING")

add_measures(d)
}
