% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/req-headers.R
\name{req_get_headers}
\alias{req_get_headers}
\title{Get request headers}
\usage{
req_get_headers(req, redacted = c("drop", "redact", "reveal"))
}
\arguments{
\item{req}{A httr2 \link{request} object.}

\item{redacted}{What to do with redacted headers?
\itemize{
\item \code{"drop"} (the default) drops them.
\item \code{"redact"} replaces them with \verb{<REDACTED>}.
\item \code{"reveal"} leaves them in place.
}}
}
\value{
A named list.
}
\description{
Retrieve custom headers set on the request. Use \code{\link[=req_dry_run]{req_dry_run()}} to get all
headers, including those automatically generated by curl.
}
\examples{
req <- request("http://example.com")
req <- req_headers(req, a = 1L, b = 2L, .redact = "a")

req_get_headers(req, "drop")
req_get_headers(req, "redact")
req_get_headers(req, "reveal")
}
