% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prManual.R
\name{.prManual}
\alias{.prManual}
\title{Manual recursive clustering using an OH matrix and a fixed threshold}
\usage{
.prManual(oh, maxsnpnooh)
}
\arguments{
\item{oh}{A numeric matrix representing opposing-homozygotes (OH) counts
between individuals. Row and column names should be individual IDs. The
matrix is expected to be square and symmetric.}

\item{maxsnpnooh}{Numeric scalar giving the maximum allowed within-group OH
value. Groups with a larger maximum OH value (and size > 2) are split
recursively.}
}
\value{
A \code{data.frame} with columns:
\describe{
  \item{id}{Individual ID (character).}
  \item{group}{An integer-like group code (generated randomly; not reproducible).}
}
}
\description{
Performs a recursive hierarchical clustering on an opposing-homozygotes (OH)
matrix using Ward clustering and splits clusters until the maximum within-
cluster OH value is below a user-supplied threshold (\code{maxsnpnooh}).
}
\details{
The function returns a two-column data frame with individual IDs and a group
code. Group codes are generated randomly (via \code{rnorm()}) and therefore
are not stable across runs.


The recursion proceeds as follows:
\enumerate{
  \item Compute a pairwise distance object from \code{oh} using \code{.fastdist}
  and convert it to a \code{dist} object.
  \item Apply hierarchical clustering using \code{\link[stats]{hclust}} with
  \code{method = "ward.D"}.
  \item Cut the dendrogram into two groups using \code{\link[stats]{cutree}}.
  \item For each group, compute the maximum within-group OH value; if it
  exceeds \code{maxsnpnooh} and the group has more than two individuals,
  recurse into that subgroup. Otherwise, write group assignments and stop.
}
}
\section{Side effects}{

This function writes to and reads from a file named \code{"temp.txt"} in the
current working directory, and then deletes it. It also prints
\code{maxsnpnooh} to the console.
}

\seealso{
\code{\link[stats]{hclust}}, \code{\link[stats]{cutree}},
  \code{\link[stats]{as.dist}}
}
\keyword{internal}
