% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_conversions.R
\name{hexify_cell_to_plane}
\alias{hexify_cell_to_plane}
\title{Convert Cell ID to PLANE coordinates}
\usage{
hexify_cell_to_plane(cell_id, resolution, aperture = 3L)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs (1-based)}

\item{resolution}{Grid resolution level (0-30)}

\item{aperture}{Grid aperture: 3, 4, or 7}
}
\value{
Data frame with columns:
\item{plane_x}{X coordinate in PLANE space (range ~0 to 5.5)}
\item{plane_y}{Y coordinate in PLANE space (range ~0 to 1.73)}
}
\description{
Converts DGGRID-compatible cell IDs directly to PLANE coordinates.
Returns the cell center in the unfolded icosahedron layout.
}
\details{
Compatible with 'dggridR' dgSEQNUM_to_PLANE().
}
\examples{
# Get PLANE coordinates for cells
plane <- hexify_cell_to_plane(cell_id = c(100, 200, 300),
                               resolution = 5, aperture = 3)
plot(plane$plane_x, plane$plane_y)
}
\seealso{
\code{\link{hexify_icosa_tri_to_plane}} for triangle conversion,
\code{\link{hexify_lonlat_to_plane}} for lon/lat conversion

Other coordinate conversion: 
\code{\link{hexify_cell_id_to_quad_ij}()},
\code{\link{hexify_cell_to_icosa_tri}()},
\code{\link{hexify_cell_to_lonlat}()},
\code{\link{hexify_cell_to_quad_ij}()},
\code{\link{hexify_cell_to_quad_xy}()},
\code{\link{hexify_grid_cell_to_lonlat}()},
\code{\link{hexify_grid_to_cell}()},
\code{\link{hexify_icosa_tri_to_plane}()},
\code{\link{hexify_icosa_tri_to_quad_ij}()},
\code{\link{hexify_icosa_tri_to_quad_xy}()},
\code{\link{hexify_lonlat_to_cell}()},
\code{\link{hexify_lonlat_to_plane}()},
\code{\link{hexify_lonlat_to_quad_ij}()},
\code{\link{hexify_quad_ij_to_cell}()},
\code{\link{hexify_quad_ij_to_icosa_tri}()},
\code{\link{hexify_quad_ij_to_xy}()},
\code{\link{hexify_quad_xy_to_cell}()},
\code{\link{hexify_quad_xy_to_icosa_tri}()},
\code{\link{hexify_roundtrip_test}()}
}
\concept{coordinate conversion}
\keyword{internal}
