% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heaping_indices.R
\name{spoorenberg}
\alias{spoorenberg}
\title{Spoorenberg's Total Modified Whipple Index}
\usage{
spoorenberg(x, ageMin = 20, ageMax = 64, weight = NULL)
}
\arguments{
\item{x}{numeric vector of individual ages.}

\item{ageMin}{minimum age to include (default 20).}

\item{ageMax}{maximum age to include (default 64).}

\item{weight}{optional numeric vector of sampling weights.}
}
\value{
A single numeric value representing the Total Modified Whipple Index.
}
\description{
The Total Modified Whipple Index extends Noumbissi's approach by summing
the absolute deviations from 1 for all ten digits, providing an overall
measure of age heaping across all terminal digits.
}
\details{
Calculate the Total Modified Whipple Index (Wtot) proposed by Spoorenberg.


The index is calculated as:
\deqn{W_{tot} = \sum_{i=0}^{9} |1 - W_i|}
where \eqn{W_i} is Noumbissi's index for digit \eqn{i}.

Interpretation:
\itemize{
  \item 0: no heaping (perfect data)
  \item Higher values indicate more heaping
  \item Maximum theoretical value is 16 (if all ages end in one digit)
}
}
\examples{
# No heaping
set.seed(42)
age_uniform <- sample(20:64, 10000, replace = TRUE)
spoorenberg(age_uniform)  # Should be close to 0

# Strong heaping on 0 and 5
age_heaped <- sample(seq(20, 60, by = 5), 5000, replace = TRUE)
spoorenberg(age_heaped)  # Should be high

}
\references{
Spoorenberg, T. and Dutreuilh, C. (2007). Quality of age reporting:
extension and application of the modified Whipple's index.
\emph{Population}, \strong{62}(4), 729-741.
}
\seealso{
\code{\link{noumbissi}} for single-digit index,
  \code{\link{whipple}} for original Whipple's index.

Other heaping indices: 
\code{\link{bachi}()},
\code{\link{coale_li}()},
\code{\link{heaping_indices}()},
\code{\link{jdanov}()},
\code{\link{kannisto}()},
\code{\link{myers}()},
\code{\link{noumbissi}()},
\code{\link{whipple}()}
}
\author{
Matthias Templ
}
\concept{heaping indices}
