% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sipni.R
\name{sipni_variables}
\alias{sipni_variables}
\title{List SI-PNI Variables}
\usage{
sipni_variables(type = "DPNI", search = NULL)
}
\arguments{
\item{type}{Character. File type to show variables for.
\code{"DPNI"} (default) for doses applied (FTP, 1994-2019),
\code{"CPNI"} for coverage (FTP, 1994-2019), or \code{"API"} for
individual-level microdata (OpenDataSUS, 2020+).}

\item{search}{Character. Optional search term to filter variables by
name or description. Case-insensitive and accent-insensitive.}
}
\value{
A tibble with columns: variable, description, type, section.
}
\description{
Returns a tibble with available variables in the SI-PNI data,
including descriptions and value types.
}
\examples{
sipni_variables()
sipni_variables(type = "CPNI")
sipni_variables(type = "API")
sipni_variables(search = "dose")
}
\seealso{
Other sipni: 
\code{\link{sipni_cache_status}()},
\code{\link{sipni_clear_cache}()},
\code{\link{sipni_data}()},
\code{\link{sipni_dictionary}()},
\code{\link{sipni_info}()},
\code{\link{sipni_years}()}
}
\concept{sipni}
