% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anvisa.R
\name{anvisa_data}
\alias{anvisa_data}
\title{Download ANVISA Data}
\usage{
anvisa_data(
  type = "medicines",
  year = NULL,
  month = NULL,
  vars = NULL,
  cache = TRUE,
  cache_dir = NULL,
  lazy = FALSE,
  backend = c("arrow", "duckdb")
)
}
\arguments{
\item{type}{Character. Type of data to download. Default: \code{"medicines"}.
Use \code{\link{anvisa_types}()} to see all 14 available types.

\strong{Snapshot types} (no year/month needed):
\code{"medicines"}, \code{"medical_devices"}, \code{"food"},
\code{"cosmetics"}, \code{"sanitizers"}, \code{"tobacco"},
\code{"pesticides"}, \code{"hemovigilance"}, \code{"technovigilance"},
\code{"vigimed_notifications"}, \code{"vigimed_medicines"},
\code{"vigimed_reactions"}.

\strong{Time-series types} (year required):
\code{"sngpc"}, \code{"sngpc_compounded"}.}

\item{year}{Integer. Year(s) of the data. Only used for SNGPC types
(2014-2026). Ignored with a warning for snapshot types.}

\item{month}{Integer. Month(s) 1-12. Only used for SNGPC types.
If NULL (default), downloads all 12 months. Ignored with a warning
for snapshot types.}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all available variables. Use \code{\link{anvisa_variables}()}
to see available variables per type.}

\item{cache}{Logical. If TRUE (default), caches downloaded data for
faster future access.}

\item{cache_dir}{Character. Directory for caching. Default:
\code{tools::R_user_dir("healthbR", "cache")}.}

\item{lazy}{Logical. If TRUE, returns a lazy query object instead of a
tibble. Only available for SNGPC types (partitioned cache). Requires
the \pkg{arrow} package. Default: FALSE.}

\item{backend}{Character. Backend for lazy evaluation: \code{"arrow"}
(default) or \code{"duckdb"}. Only used when \code{lazy = TRUE}.}
}
\value{
A tibble with ANVISA data. SNGPC types include \code{year} and
\code{month} partition columns.
}
\description{
Downloads and returns data from the ANVISA (Agencia Nacional de Vigilancia
Sanitaria) open data portal. Supports 14 data types across 4 categories:
product registrations, reference tables, post-market surveillance, and
controlled substance sales (SNGPC).
}
\details{
Data is downloaded from the ANVISA open data portal at
\verb{https://dados.anvisa.gov.br/dados/}.

\strong{Snapshot types}: Download a single CSV file representing the
current state of the registry/database. No time dimension. Cached as
flat files.

\strong{SNGPC types}: Monthly CSV files with controlled substance sales
data. Data available from January 2014 to October 2021, with new data
from January 2026. Cached as Hive-style partitioned parquet datasets.

The three VigiMed types share the \code{IDENTIFICACAO_NOTIFICACAO} key
for linking notifications, medicines, and reactions.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# registered medicines
med <- anvisa_data(type = "medicines")

# hemovigilance notifications
hemo <- anvisa_data(type = "hemovigilance")

# SNGPC controlled substance sales, Jan 2020
sngpc <- anvisa_data(type = "sngpc", year = 2020, month = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{anvisa_types}()} for available types,
\code{\link{anvisa_variables}()} for variable descriptions.

Other anvisa: 
\code{\link{anvisa_cache_status}()},
\code{\link{anvisa_clear_cache}()},
\code{\link{anvisa_info}()},
\code{\link{anvisa_types}()},
\code{\link{anvisa_variables}()}
}
\concept{anvisa}
