% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ans.R
\name{ans_data}
\alias{ans_data}
\title{Download ANS Data}
\usage{
ans_data(
  year,
  type = "beneficiaries",
  uf = NULL,
  month = NULL,
  quarter = NULL,
  vars = NULL,
  cache = TRUE,
  cache_dir = NULL,
  lazy = FALSE,
  backend = c("arrow", "duckdb")
)
}
\arguments{
\item{year}{Integer. Year(s) of the data. Required.}

\item{type}{Character. Type of data. One of:
\itemize{
\item \code{"beneficiaries"}: Consolidated beneficiary counts (default).
Uses \code{year}, \code{month}, \code{uf} parameters.
\item \code{"complaints"}: Consumer complaints via NIP.
Uses \code{year} only (national data).
\item \code{"financial"}: Financial statements.
Uses \code{year}, \code{quarter} parameters.
}}

\item{uf}{Character. Two-letter state abbreviation(s). Only used for
\code{type = "beneficiaries"}. Includes \code{"XX"} for unidentified
beneficiaries. If NULL (default), downloads all 27 states.}

\item{month}{Integer. Month(s) 1-12. Only used for
\code{type = "beneficiaries"}. If NULL (default), downloads all months.
Note: 2019 starts at month 4 (April).}

\item{quarter}{Integer. Quarter(s) 1-4. Only used for
\code{type = "financial"}. If NULL (default), downloads all 4 quarters.}

\item{vars}{Character vector. Variables to keep. If NULL (default),
returns all available variables. Use \code{\link{ans_variables}()}
to see available variables per type.}

\item{cache}{Logical. If TRUE (default), caches downloaded data for
faster future access.}

\item{cache_dir}{Character. Directory for caching. Default:
\code{tools::R_user_dir("healthbR", "cache")}.}

\item{lazy}{Logical. If TRUE, returns a lazy query object instead of a
tibble. Requires the \pkg{arrow} package. Default: FALSE.}

\item{backend}{Character. Backend for lazy evaluation: \code{"arrow"}
(default) or \code{"duckdb"}. Only used when \code{lazy = TRUE}.}
}
\value{
A tibble with ANS data. Includes partition columns:
\code{year} (all types), \code{month} and \code{uf_source}
(beneficiaries), \code{quarter} (financial).
}
\description{
Downloads and returns data from the ANS (Agencia Nacional de Saude
Suplementar) open data portal. Supports three data types: beneficiary
counts, consumer complaints (NIP), and financial statements.
}
\details{
Data is downloaded from the ANS open data portal at
\verb{https://dadosabertos.ans.gov.br/}.

\strong{Beneficiaries}: Monthly per-state ZIP files containing CSV data
with consolidated beneficiary counts by operator, plan type, sex, age
group, and municipality. Available from April 2019.

\strong{Complaints}: Annual national CSV files with consumer complaints
filed through the NIP (Notificacao de Intermediacao Preliminar).
Available from 2011.

\strong{Financial}: Quarterly ZIP files with financial statements of
health plan operators (balance sheets, income statements).
Available from 2007.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# beneficiary counts for Acre, December 2023
ac <- ans_data(year = 2023, month = 12, uf = "AC")

# consumer complaints for 2022
nip <- ans_data(year = 2022, type = "complaints")

# financial statements Q1 2023
fin <- ans_data(year = 2023, type = "financial", quarter = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{ans_operators}()} for the operator registry,
\code{\link{ans_variables}()} for variable descriptions.

Other ans: 
\code{\link{ans_cache_status}()},
\code{\link{ans_clear_cache}()},
\code{\link{ans_info}()},
\code{\link{ans_operators}()},
\code{\link{ans_variables}()},
\code{\link{ans_years}()}
}
\concept{ans}
