/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Dmodule.h" 
#define H5D_TESTING    

#include "H5private.h"   
#include "H5Dpkg.h"      
#include "H5Eprivate.h"  
#include "H5Iprivate.h"  
#include "H5VLprivate.h" 

herr_t
H5D__layout_version_test(hid_t did, unsigned *version)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_DATASET, H5E_BADTYPE, FAIL, "not a dataset");

    if (version)
        *version = dset->shared->layout.version;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5D__layout_contig_size_test(hid_t did, hsize_t *size)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_DATASET, H5E_BADTYPE, FAIL, "not a dataset");

    if (size) {
        assert(dset->shared->layout.type == H5D_CONTIGUOUS);
        *size = dset->shared->layout.storage.u.contig.size;
    } 

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5D__layout_compact_dirty_test(hid_t did, bool *dirty)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_DATASET, H5E_BADTYPE, FAIL, "not a dataset");

    if (dirty) {
        assert(dset->shared->layout.type == H5D_COMPACT);
        *dirty = dset->shared->layout.storage.u.compact.dirty;
    } 

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5D__layout_type_test(hid_t did, H5D_layout_t *layout_type)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    assert(layout_type);

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a dataset");

    if (layout_type)
        *layout_type = dset->shared->layout.type;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5D__layout_idx_type_test(hid_t did, H5D_chunk_index_t *idx_type)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a dataset");
    if (dset->shared->layout.type != H5D_CHUNKED)
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "dataset is not chunked");

    if (idx_type)
        *idx_type = dset->shared->layout.u.chunk.idx_type;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5D__current_cache_size_test(hid_t did, size_t *nbytes_used, int *nused)
{
    H5D_t *dset;                
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE

    
    if (NULL == (dset = (H5D_t *)H5VL_object_verify(did, H5I_DATASET)))
        HGOTO_ERROR(H5E_ARGS, H5E_BADTYPE, FAIL, "not a dataset");

    if (nbytes_used) {
        assert(dset->shared->layout.type == H5D_CHUNKED);
        *nbytes_used = dset->shared->cache.chunk.nbytes_used;
    } 

    if (nused) {
        assert(dset->shared->layout.type == H5D_CHUNKED);
        *nused = dset->shared->cache.chunk.nused;
    } 

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
