/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5TSmodule.h" 

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5TSpkg.h"    

#ifdef H5_HAVE_THREADS

#ifdef H5_HAVE_C11_THREADS

herr_t
H5TS_cond_init(H5TS_cond_t *cond)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    if (H5_UNLIKELY(cnd_init(cond) != thrd_success))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 

herr_t
H5TS_cond_destroy(H5TS_cond_t *cond)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    
    cnd_destroy(cond);

    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(SUCCEED)
} 

#else
#ifdef H5_HAVE_WIN_THREADS

herr_t
H5TS_cond_init(H5TS_cond_t *cond)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    InitializeConditionVariable(cond);

    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(SUCCEED)
} 

herr_t
H5TS_cond_destroy(H5TS_cond_t *cond)
{
    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    

    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(SUCCEED)
} 
#else

herr_t
H5TS_cond_init(H5TS_cond_t *cond)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    if (H5_UNLIKELY(pthread_cond_init(cond, NULL)))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 

herr_t
H5TS_cond_destroy(H5TS_cond_t *cond)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_NOAPI_NAMECHECK_ONLY

    if (H5_UNLIKELY(pthread_cond_destroy(cond)))
        HGOTO_DONE(FAIL);

done:
    FUNC_LEAVE_NOAPI_NAMECHECK_ONLY(ret_value)
} 

#endif
#endif

#endif 
