% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWP.R
\name{IWP}
\alias{IWP}
\title{Calculates patient-level individual win proportions}
\usage{
IWP(data, AVAL, TRTP, ref)
}
\arguments{
\item{data}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{ref}{the reference treatment group.}
}
\value{
the input data frame with a new column of individual win proportions named using the input \code{AVAL} value with \verb{_}.
}
\description{
Calculates patient-level individual win proportions
}
\examples{
KHCE1 <- IWP(data = KHCE, AVAL = "EGFRBL", TRTP = "TRTPN", ref = 2)
WP <- tapply(KHCE1$EGFRBL_, KHCE1$TRTPN, mean)
VAR <- tapply(KHCE1$EGFRBL_, KHCE1$TRTPN, function(x) (length(x)-1)*var(x)/length(x))
N <- tapply(KHCE1$EGFRBL_, KHCE1$TRTPN, length)
SE <- sqrt(sum(VAR/N))
c(WP = WP[[1]], SE = SE)
calcWO(EGFRBL ~ TRTP, data = KHCE)[c("WP", "SE_WP")]
}
\references{
Gasparyan SB et al. "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2 (2021): 580-611. \url{doi:10.1177/0962280220942558}.
}
\seealso{
\code{\link[=calcWO]{calcWO()}}, \code{\link[=calcWO.hce]{calcWO.hce()}}, \code{\link[=calcWO.formula]{calcWO.formula()}}.
}
