% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_amoc.R
\name{hcp_amoc}
\alias{hcp_amoc}
\title{At Most One Change (AMOC)}
\usage{
hcp_amoc()
}
\value{
\code{hcp_amoc} object.
}
\description{
Change-point detection method focusing on identifying at most one change in
mean and/or variance. This is a wrapper around the AMOC implementation from
the \code{changepoint} package.
}
\details{
AMOC detects a single most significant change point under a cost function
optimized for a univariate series. It is useful when at most one structural
break is expected.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure the AMOC detector
model <- hcp_amoc()

# Fit the detector (no-op for AMOC)
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change point(s)
print(detection[(detection$event),])

}
\references{
\itemize{
\item Hinkley DV (1970). Inference about the change-point in a sequence of random variables. Biometrika, 57(1):1–17. doi:10.1093/biomet/57.1.1
\item Killick R, Fearnhead P, Eckley IA (2012). Optimal detection of changepoints with a linear computational cost. JASA, 107(500):1590–1598.
}
}
