% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Apply.calendar.censoring.2.R
\name{Apply.calendar.censoring.2}
\alias{Apply.calendar.censoring.2}
\title{Function to apply a given calendar time as effective censoring time for two-sample composite endpoint data.}
\usage{
Apply.calendar.censoring.2(data, calendar)
}
\arguments{
\item{data}{A data frame generated by \code{TwoSample.generate.sequential()} containing simulated two-sample composite endpoint
data in long format.}

\item{calendar}{A positive numeric value specifying the calendar time (in years) at which administrative censoring is applied.}
}
\value{
A data frame in long format containing the censored composite endpoint data. Each subject contributes all events occurring
on or before the specified calendar time, with an additional censoring record added for subjects who have not
experienced a terminal event by that time.
}
\description{
Applies administrative censoring at a specified calendar time by truncating
each subject’s observed event history; for subjects still under observation
at the calendar cutoff, a censoring record is added at the cutoff time.
}
\examples{
df <- TwoSample.generate.sequential(sizevec = c(100, 100), beta.trt = 0.8,
calendar = 5, recruitment = 3,
random.censor.rate = 0.05, seed = 2026)
df2 <- Apply.calendar.censoring.2(data= df, calendar = 3.9)
}
