% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branding.R
\name{brand_css}
\alias{brand_css}
\title{Generate CSS from brand configuration}
\usage{
brand_css(brand = "block", output_file = NULL, minify = FALSE)
}
\arguments{
\item{brand}{Name of the brand}

\item{output_file}{Path to save CSS file (NULL to return as string)}

\item{minify}{Minify the CSS output (default: FALSE)}
}
\value{
CSS content as string (invisibly if saved to file)
}
\description{
Generate CSS from brand configuration
}
\examples{
\dontrun{
# Save to file in temp directory
temp_file <- file.path(tempdir(), "block.css")
brand_css("block", temp_file)

# Get as string
css <- brand_css("block")
}
}
