% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_genesets_go.R
\name{go_obo}
\alias{go_obo}
\title{simple vectorized parsing of GO OBO file without any dependencies (beyond dplyr/tibble/tidyr)}
\usage{
go_obo(f, rename_namespace = TRUE, remove_obsolete = TRUE)
}
\arguments{
\item{f}{full path to go.obo file stored on the computer, e.g. previously downloaded from http://current.geneontology.org/ontology/go.obo . Also works with a gzipped file; obo.gz}

\item{rename_namespace}{boolean; rename official namespace values like 'cellular_component' to CC? (analogous for BP and MF)}

\item{remove_obsolete}{boolean; remove obsoleted terms?}
}
\value{
tibble with ontology terms and their relations
}
\description{
note that we remove links between GO terms that are across GO domains (e.g. no CC to MF relations)
The only supported relations are those that match this regex;
\code{"^(is_a:|relationship: part_of|relationship: regulates|relationship: positively_regulates|relationship: negatively_regulates)"}
}
