% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea_pathway_annotation.R
\name{gsea_pathway_annotation}
\alias{gsea_pathway_annotation}
\title{Annotate GSEA results with pathway information}
\usage{
gsea_pathway_annotation(gsea_results, pathway_type = "KEGG")
}
\arguments{
\item{gsea_results}{A data frame containing GSEA results from the pathway_gsea function}

\item{pathway_type}{A character string specifying the pathway type: "KEGG", "MetaCyc", or "GO"}
}
\value{
A data frame with annotated GSEA results
}
\description{
This function adds pathway annotations to GSEA results, including pathway names,
descriptions, and classifications.
}
\examples{
\dontrun{
# Load example data
data(ko_abundance)
data(metadata)

# Prepare abundance data
abundance_data <- as.data.frame(ko_abundance)
rownames(abundance_data) <- abundance_data[, "#NAME"]
abundance_data <- abundance_data[, -1]

# Run GSEA analysis (using camera method - recommended)
gsea_results <- pathway_gsea(
  abundance = abundance_data,
  metadata = metadata,
  group = "Environment",
  pathway_type = "KEGG",
  method = "camera"
)

# Annotate results
annotated_results <- gsea_pathway_annotation(
  gsea_results = gsea_results,
  pathway_type = "KEGG"
)
}
}
