% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{ggml_dup}
\alias{ggml_dup}
\title{Duplicate Tensor (Graph)}
\usage{
ggml_dup(ctx, a)
}
\arguments{
\item{ctx}{GGML context}

\item{a}{Input tensor}
}
\value{
Tensor representing the copy operation
}
\description{
Creates a graph node that copies a tensor. This is a graph operation
that must be computed using ggml_build_forward_expand() and ggml_graph_compute().
Unlike ggml_dup_tensor which just allocates, this creates a copy operation in the graph.
}
\examples{
\donttest{
ctx <- ggml_init(1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 5)
ggml_set_f32(a, c(1, 2, 3, 4, 5))
b <- ggml_dup(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)
ggml_graph_compute(ctx, graph)
ggml_get_f32(b)
ggml_free(ctx)
}
}
