% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t50.R
\name{t50}
\alias{t50}
\title{Median germination time}
\usage{
t50(germ.counts, intervals, partial = TRUE, method = c("coolbear", "farooq"))
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{method}{The method for computing median germination time. Either
\code{"coolbear"} or \code{"farooq"}.}
}
\value{
The median germination time (\mjseqn{t_{50}}) value in the same unit
  of time as specified in the argument \code{intervals}.
}
\description{
Compute the median germination time (\mjseqn{t_{50}}). Median germination
time is the time to reach 50\% of final/maximum germination. \loadmathjax
}
\details{
With argument \code{method} specified as \code{"coolbear"}, median
germination time is computed according to the formula by
\insertCite{coolbear_effect_1984;textual}{germinationmetrics} as follows.

\mjsdeqn{t_{50}=T_{i}+
\frac{(\frac{N+1}{2}-N_{i})(T_{j}-T_{i})}{N_{j}-N_{i}}}

Where, \mjseqn{t_{50}} is the median germination time, \mjseqn{N} is the
final number of germinated seeds, and \mjseqn{N_{i}} and \mjseqn{N_{j}} are
the total number of seeds germinated in adjacent counts at time
\mjseqn{T_{i}} and \mjseqn{T_{j}} respectively, when \mjseqn{N_{i} < \frac{N
+ 1}{2} < N_{j}}.

Similarly with argument \code{method} specified as \code{"farooq"}, median
germination time is computed according to the formula by  by
\insertCite{farooq_thermal_2005;textual}{germinationmetrics} as follows.

\mjsdeqn{t_{50}=T_{i}+ \frac{(\frac{N}{2}-N_{i})(T_{j}-T_{i})}{N_{j}-N_{i}}}

Where, \mjseqn{t_{50}} is the median germination time, \mjseqn{N} is the
final number of germinated seeds, and \mjseqn{N_{i}} and \mjseqn{N_{j}} are
the total number of seeds germinated in adjacent counts at time
\mjseqn{T_{i}} and \mjseqn{T_{j}} respectively, when \mjseqn{N_{i} <
\frac{N}{2} < N_{j}}.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
t50(germ.counts = x, intervals = int, method = "coolbear")
t50(germ.counts = x, intervals = int, method = "farooq")

# From cumulative germination counts
#----------------------------------------------------------------------------
t50(germ.counts = y, intervals = int, partial = FALSE, method = "coolbear")
t50(germ.counts = y, intervals = int, partial = FALSE, method = "farooq")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{MeanGermRate}}
}
