% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sploglik.R
\name{sploglik_cross}
\alias{sploglik_cross}
\title{Spatial log likelihood}
\usage{
sploglik_cross(runs, transf = c("no", "mu", "wo"))
}
\arguments{
\item{runs}{A list with outputs from the function
\code{\link{mcsglmm}} or \code{\link{mcstrga}}.}

\item{transf}{Whether to use a transformed sample for the
computations. If \code{"no"} or \code{FALSE}, it doesn't. If
\code{"mu"} or \code{TRUE}, it uses the samples for the mean. If
\code{"wo"} it uses an alternative transformation. The latter
can be used only for the families indicated by
\code{.geoBayes_models$haswo}. The input can also be a vector
(of the same length as \code{runs} to allow for different
transformation to be used when evaluating each likelihood.}
}
\value{
A matrix with number of rows the total number of samples
  in runs and number of columns the length of \code{runs}. The
  [i,j] element of the matrix is the value of the loglikelihood at
  the ith sample when all samples in \code{runs} are put together evaluated
  at the jth parameter value.
}
\description{
Spatial joint log likelihood
}
\details{
Computes the joint log likelihood log f(y,T(z)|parameters) where
T(z) is the transformation, for each (y,z) in runs and for parameters
in runs up to a constant which does not depend on the parameters.
The parameters beta and sigma^2 are integrated out.
}
