% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{dimension_values}
\alias{dimension_values}
\title{Query coordinate values for all dimensions of a data cube}
\usage{
dimension_values(obj, datetime_unit = NULL)
}
\arguments{
\item{obj}{a data cube proxy (class cube), or a data cube view object}

\item{datetime_unit}{unit used to format values in the datetime dimension, one of "Y", "m", "d", "H", "M", "S", defaults to the unit of the cube.}
}
\value{
list with elements t,y,x
}
\description{
Dimension values give the coordinates along the spatial and temporal axes of a data cube.
}
\examples{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db"), quiet = TRUE) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4, 
              bottom=4345299, top=4744931, t0="2018-04", t1="2018-06"),
              srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
dimension_values(raster_cube(L8.col, v))
}
