% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{save_notebook}
\alias{save_notebook}
\title{Save a rendered notebook to the outputs directory}
\usage{
save_notebook(
  file,
  name = NULL,
  format = "html",
  public = FALSE,
  overwrite = TRUE,
  embed_resources = TRUE,
  ...
)
}
\arguments{
\item{file}{Path to the .qmd or .Rmd file to render}

\item{name}{Optional new name for the output file (without extension). If NULL,
uses the original notebook name.}

\item{format}{Output format: "html" (default), "pdf", or "docx"}

\item{public}{If TRUE, saves to public outputs directory (for project_sensitive type)}

\item{overwrite}{If TRUE, overwrites existing files (default: TRUE)}

\item{embed_resources}{If TRUE, creates a self-contained file with embedded resources
(default: TRUE for html format)}

\item{...}{Additional arguments passed to quarto render}
}
\value{
The path to the saved file (invisibly)
}
\description{
Renders a Quarto or R Markdown notebook and saves the output to the configured
notebooks output directory. The directory is created lazily on first use.
}
\examples{
\donttest{
if (FALSE) {
# Render and save a notebook
save_notebook("notebooks/analysis.qmd")

# Save with a custom name
save_notebook("notebooks/analysis.qmd", name = "final_analysis")

# Render to PDF
save_notebook("notebooks/analysis.qmd", format = "pdf")

# Save to public directory (for sensitive projects)
save_notebook("notebooks/analysis.qmd", public = TRUE)
}
}

}
