% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{configure_connection}
\alias{configure_connection}
\title{Configure Database Connection}
\usage{
configure_connection(
  name = NULL,
  driver = NULL,
  host = NULL,
  port = NULL,
  database = NULL,
  user = NULL,
  password = NULL,
  interactive = TRUE
)
}
\arguments{
\item{name}{Character. Connection name (e.g., "db", "warehouse")}

\item{driver}{Character. Database driver: "sqlite", "postgresql", "mysql", etc.}

\item{host}{Character. Database host (for network databases)}

\item{port}{Integer. Database port (for network databases)}

\item{database}{Character. Database name}

\item{user}{Character. Database user (for network databases)}

\item{password}{Character. Database password (stored in .env)}

\item{interactive}{Logical. If TRUE, prompts for missing values. Default TRUE.}
}
\value{
Invisibly returns updated config
}
\description{
Interactively add a database connection to settings.yml (or settings.yml for legacy projects). Connections can be
defined inline or in a split file (settings/connections.yml).
}
\keyword{internal}
