% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_read.R
\name{cache_remember}
\alias{cache_remember}
\title{Remember a value (get from cache or compute and store)}
\usage{
cache_remember(
  name,
  expr,
  file = NULL,
  expire_after = NULL,
  refresh = FALSE,
  expire = NULL
)
}
\arguments{
\item{name}{The cache name (non-empty string identifier)}

\item{expr}{The expression to evaluate and cache if cache miss occurs.
Expression is evaluated in the parent frame.}

\item{file}{Optional file path to store the cache
(default: \verb{cache/\{name\}.rds})}

\item{expire_after}{Optional expiration time in hours
(default: from config). Character durations like "1 day" or "2 hours" are accepted.}

\item{refresh}{Optional boolean or function that returns boolean to force
refresh. If TRUE or if function returns TRUE, cache is invalidated and
expression is re-evaluated.}

\item{expire}{Optional alias for \code{expire_after} (accepts the same formats)}
}
\value{
The cached value (if cache hit) or the result of evaluating expr
(if cache miss or refresh requested)
}
\description{
Attempts to retrieve a cached value by name. If the cache doesn't exist,
is expired, or a refresh is requested, evaluates the expression and caches
the result. This is the primary caching interface for expensive computations.
}
\examples{
\donttest{
if (FALSE) {
# Cache expensive computation
result <- cache_remember("my_analysis", {
  expensive_computation()
})

# Force refresh when data changes
result <- cache_remember("analysis", {
  run_analysis()
}, refresh = file.mtime("data.csv") > cache_time)
}
}

}
