% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peek-guess-delim.R
\name{peek_guess_delim}
\alias{peek_guess_delim}
\title{Guess Delimited File Parameters}
\usage{
peek_guess_delim(
  path,
  delims = c(",", "\\t", " ", "|", ":", ";"),
  quotes = c("\\"", "'"),
  n = 1024
)
}
\arguments{
\item{path}{path to the text file.}

\item{delims}{character vector of candidate delimiters.}

\item{quotes}{character vector of candidate quote characters.}

\item{n}{number of lines to read for guessing (default 1024).}
}
\value{
a named list with elements:
\describe{
  \item{delim}{the guessed delimiter character (or \code{NULL})}
  \item{quote}{the guessed quote character (or \code{NULL})}
  \item{decimal_mark}{the guessed decimal mark (or \code{NULL})}
}
}
\description{
Guess the delimiter, quote character and decimal mark of a
delimited text file. The function splits each of the first
\code{n} lines by each candidate delimiter and selects the
delimiter that produces the most consistent number of fields.

The algorithm is adapted from the vroom package.
}
\examples{
f <- system.file(package = "fpeek",
  "datafiles", "test-comma.csv")
peek_guess_delim(f)

f <- system.file(package = "fpeek",
  "datafiles", "test-semicolon.csv")
peek_guess_delim(f)
}
