% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{hrf_set}
\alias{hrf_set}
\alias{gen_hrf_set}
\title{Generate an HRF Basis Set}
\usage{
hrf_set(..., name = "hrf_set")

gen_hrf_set(...)
}
\arguments{
\item{...}{One or more HRF objects.}

\item{name}{The name for the combined HRF set.}
}
\value{
A combined HRF object.
}
\description{
`hrf_set` constructs an HRF basis set from one or more component HRF objects.
}
\examples{
# Combine multiple HRF types into a basis set
hrf_basis <- hrf_set(HRF_SPMG1, HRF_GAUSSIAN, HRF_GAMMA)

# Create custom basis with different parameters
hrf1 <- gen_hrf(hrf_gamma, alpha = 6, beta = 1)
hrf2 <- gen_hrf(hrf_gamma, alpha = 8, beta = 1)
custom_basis <- hrf_set(hrf1, hrf2, name = "custom_gamma_basis")

# Evaluate the basis set
t <- seq(0, 30, by = 0.1)
basis_response <- evaluate(hrf_basis, t)
}
\keyword{internal}
