% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf-functions.R
\name{hrf_gaussian}
\alias{hrf_gaussian}
\title{Gaussian HRF (hemodynamic response function)}
\usage{
hrf_gaussian(t, mean = 6, sd = 2)
}
\arguments{
\item{t}{A vector of time points.}

\item{mean}{A numeric value representing the mean of the Gaussian probability density function. Default value is 6.}

\item{sd}{A numeric value representing the standard deviation of the Gaussian probability density function. Default value is 2.}
}
\value{
A numeric vector representing the Gaussian HRF at the given time points `t`.
}
\description{
The `hrf_gaussian` function computes the Gaussian density-based HRF (hemodynamic response function) at given time points `t`.
}
\examples{
# Compute the Gaussian HRF representation for time points from 0 to 20 with 0.5 increments
hrf_gaussian_vals <- hrf_gaussian(seq(0, 20, by = .5), mean = 6, sd = 2)
}
\seealso{
Other hrf_functions: 
\code{\link{hrf_basis_lwu}()},
\code{\link{hrf_boxcar}()},
\code{\link{hrf_bspline}()},
\code{\link{hrf_gamma}()},
\code{\link{hrf_inv_logit}()},
\code{\link{hrf_lwu}()},
\code{\link{hrf_mexhat}()},
\code{\link{hrf_sine}()},
\code{\link{hrf_spmg1}()},
\code{\link{hrf_time}()},
\code{\link{hrf_weighted}()}
}
\concept{hrf_functions}
