% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmriAR-package.R
\docType{package}
\name{fmriAR-package}
\alias{fmriAR-package}
\alias{fmriAR}
\title{fmriAR: Fast AR and ARMA Noise Whitening for Functional MRI (fMRI) Design and Data}
\description{
Lightweight utilities to estimate autoregressive (AR) and autoregressive moving average (ARMA) noise models from residuals and apply matched generalized least squares to whiten functional magnetic resonance imaging (fMRI) design and data matrices. The ARMA estimator follows a classic 1982 approach \doi{10.1093/biomet/69.1.81}, and a restricted AR family mirrors workflows described by Cox (2012) \doi{10.1016/j.neuroimage.2011.08.056}.

Estimate AR/ARMA noise models from residuals and apply matched GLS
prewhitening to fMRI design and data matrices. Run-aware and censor-aware.
}
\details{
The fmriAR package provides efficient implementations for:
\itemize{
\item AR and ARMA model estimation from fMRI residuals
\item Run-aware and censor-aware whitening transformations
\item Parcel-based parameter pooling
\item Sandwich standard error computation
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://bbuchsbaum.github.io/fmriAR/}
}


Useful links:
\itemize{
\item \code{\link{fit_noise}} for noise model estimation
\item \code{\link{whiten_apply}} for applying whitening transformations
\item \code{\link{whiten}} for one-step whitening
}
}
\author{
\strong{Maintainer}: Bradley Buchsbaum \email{brad.buchsbaum@gmail.com}

}
\keyword{internal}
