% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{line_spacing}
\alias{line_spacing}
\title{Set line spacing}
\usage{
line_spacing(x, i = NULL, j = NULL, space = 1, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{space}{space between lines of text; 1 is single line spacing, 2 is double line spacing.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' can be used.}
}
\description{
Change the line spacing of selected rows and columns of a flextable.
}
\examples{
ft <- flextable(head(mtcars)[, 3:6])
ft <- line_spacing(ft, space = 1.6, part = "all")
ft <- set_table_properties(ft, layout = "autofit")
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{font}()},
\code{\link{fontsize}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{keep_with_next}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{style}()},
\code{\link{tab_settings}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
