% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{shift_level_max}
\alias{shift_level_max}
\alias{shift_var_max}
\alias{shift_kl_max}
\title{Sliding window features}
\usage{
shift_level_max(x, .size = NULL, .period = 1)

shift_var_max(x, .size = NULL, .period = 1)

shift_kl_max(x, .size = NULL, .period = 1)
}
\arguments{
\item{x}{a univariate time series}

\item{.size}{size of sliding window, if NULL \code{.size} will be automatically chosen using \code{.period}}

\item{.period}{The seasonal period (optional)}
}
\value{
A vector of 2 values: the size of the shift, and the time index of the shift.
}
\description{
Computes feature of a time series based on sliding (overlapping) windows.
\code{shift_level_max} finds the largest mean shift between two consecutive windows.
\code{shift_var_max} finds the largest var shift between two consecutive windows.
\code{shift_kl_max} finds the largest shift in Kulback-Leibler divergence between
two consecutive windows.
}
\details{
Computes the largest level shift and largest variance shift in sliding mean calculations
}
\author{
Earo Wang, Rob J Hyndman and Mitchell O'Hara-Wild
}
