% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsorize.R
\name{winsorize}
\alias{winsorize}
\title{Winsorize a vector}
\usage{
winsorize(x, prob = 0.01, p_low = prob, p_high = 1 - prob)
}
\arguments{
\item{x}{A vector to be winsorized}

\item{prob}{Level (two-sided) for winsorization (e.g., 0.01 gives 1\% and 99\%)}

\item{p_low}{Optional lower level for winsorization (e.g., 0.01 gives 1\%)}

\item{p_high}{Optional upper level for winsorization (e.g., 0.99 gives 99\%)}
}
\value{
vector
}
\description{
Winsorize a vector at \code{prob} and \code{1 - prob}.
}
\examples{
winsorized <- winsorize(1:100, prob = 0.05)
min(winsorized, na.rm = TRUE)
max(winsorized, na.rm = TRUE)
}
