% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_power.R
\name{stat_power}
\alias{stat_power}
\title{Calculate Statistical Power}
\usage{
stat_power(
  n,
  effect_size,
  test = c("t.test", "anova", "proportion", "correlation", "chisq"),
  type = c("two.sample", "one.sample", "paired"),
  alternative = c("two.sided", "less", "greater"),
  alpha = 0.05,
  k = NULL,
  df = NULL,
  plot = TRUE,
  plot_range = NULL,
  palette = "qual_vivid",
  verbose = TRUE
)
}
\arguments{
\item{n}{Integer. Sample size. Interpretation depends on test type:
\itemize{
\item t-tests and ANOVA: Sample size per group
\item Proportion test: Total sample size (one-sample test)
\item Correlation: Total number of paired observations
\item Chi-square: Total sample size
}}

\item{effect_size}{Numeric. Effect size appropriate for the test (must be positive):
\itemize{
\item Cohen's d for t-tests (small: 0.2, medium: 0.5, large: 0.8)
\item Cohen's f for ANOVA (small: 0.1, medium: 0.25, large: 0.4)
\item Cohen's h for proportion tests (small: 0.2, medium: 0.5, large: 0.8)
\item Correlation coefficient r for correlation tests (small: 0.1, medium: 0.3, large: 0.5).
Use absolute value; power is the same for positive and negative correlations.
\item Cohen's w for chi-square tests (small: 0.1, medium: 0.3, large: 0.5)
}}

\item{test}{Character. Type of statistical test: "t.test" (default), "anova",
"proportion", "correlation", or "chisq".}

\item{type}{Character. For t-tests only: "two.sample" (default), "one.sample", or "paired".}

\item{alternative}{Character. Direction of alternative hypothesis: "two.sided" (default),
"less", or "greater". Note: Only applicable to t-tests, proportion tests, and
correlation tests. Ignored for ANOVA and chi-square tests (which are inherently non-directional).}

\item{alpha}{Numeric. Significance level (Type I error rate). Default: 0.05.}

\item{k}{Integer. Number of groups (required for ANOVA).}

\item{df}{Integer. Degrees of freedom (required for chi-square tests).}

\item{plot}{Logical. Generate a power curve plot? Default: TRUE.}

\item{plot_range}{Numeric vector of length 2. Range of sample sizes for the power
curve. If NULL (default), automatically determined.}

\item{palette}{Character. evanverse palette name for the plot. Default: "qual_vivid".}

\item{verbose}{Logical. Print detailed diagnostic information? Default: TRUE.}
}
\value{
An object of class \code{stat_power_result} containing:
\describe{
\item{power}{The calculated statistical power (probability of detecting the effect)}
\item{n}{Sample size used in the calculation}
\item{effect_size}{Effect size used in the calculation}
\item{alpha}{Significance level}
\item{test_type}{Type of statistical test}
\item{test_subtype}{Subtype for t-tests (e.g., "two.sample", "one.sample", "paired"); NULL for other tests}
\item{alternative}{Direction of alternative hypothesis used in the test}
\item{k}{Number of groups (for ANOVA); NULL for other tests}
\item{df}{Degrees of freedom (for chi-square tests); NULL for other tests}
\item{plot}{ggplot2 object showing the power curve (if plot = TRUE); NULL otherwise}
\item{pwr_object}{Raw result object from the \pkg{pwr} package function}
\item{details}{List with interpretation and recommendation text}
\item{timestamp}{POSIXct timestamp of when the calculation was performed}
}
}
\description{
Compute the statistical power (probability of correctly rejecting the null
hypothesis) for a given sample size, effect size, and significance level.
Supports multiple test types including t-tests, ANOVA, proportion tests,
correlation tests, and chi-square tests.
}
\details{
Statistical power is the probability of correctly rejecting the null hypothesis
when it is false (i.e., detecting a true effect). Conventionally, a power of
0.8 (80\%) is considered adequate, though higher power (0.9 or 0.95) may be
desirable in some contexts.

The function uses the \pkg{pwr} package for all power calculations, ensuring
accurate results based on well-established statistical theory.
}
\section{Test-Specific Notes}{

\strong{Proportion Test:} Uses \code{pwr.p.test}, which is for one-sample
proportion tests (testing a single proportion against a hypothesized value).
For two-sample proportion tests, consider using specialized tools or packages.
The \code{effect_size} parameter uses Cohen's h, which quantifies the difference
between two proportions. In one-sample settings, Cohen's h is computed from the
observed proportion \emph{p} and the null hypothesis proportion \emph{p0}.
}

\section{Power Curve}{

When \code{plot = TRUE}, a power curve is generated showing how statistical
power changes with sample size. The curve helps visualize:
\itemize{
\item The current power level (marked with a red point)
\item The conventional 0.8 power threshold (red dashed line)
\item How increasing sample size affects power
}
}

\examples{
\dontrun{
# Example 1: Power for a two-sample t-test
result <- stat_power(
  n = 30,
  effect_size = 0.5,
  test = "t.test",
  type = "two.sample"
)
print(result)
plot(result)

# Example 2: Power for ANOVA with 3 groups
stat_power(
  n = 25,
  effect_size = 0.25,
  test = "anova",
  k = 3
)

# Example 3: Power for correlation test
stat_power(
  n = 50,
  effect_size = 0.3,
  test = "correlation"
)
}


}
