% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hte_qoi.R
\name{compute_qoi_user}
\alias{compute_qoi_user}
\title{Compute Quantities of Interest (GATE, GATEcv, URATE) with user defined functions}
\usage{
compute_qoi_user(user_hte, Tcv, Ycv, data, ngates, ...)
}
\arguments{
\item{user_hte}{A user-defined function to estimate heterogeneous treatment effects (HTE). The function should take the data as input and return an unit-level continuous score for treatment assignment. We assume those that have score less than 0 should not have treatment. The default is \code{NULL}, which means the heterogeneous treatment effects will be estimated from by the package.}

\item{Tcv}{A vector of the unit-level binary treatment.}

\item{Ycv}{A vector of the unit-level continuous outcome.}

\item{data}{A data frame containing the variables of interest.}

\item{ngates}{The number of gates to be used in the GATE function.}

\item{...}{Additional arguments to be passed to the user-defined function.}
}
\description{
Compute Quantities of Interest (GATE, GATEcv, URATE) with user defined functions
}
