#'Sample Of Experimental And Observational Climate Spatial Data 
#'
#'This sample data contain gridded seasonal forecast and corresponding 
#'observational data from ECMWF-System 5 forecast system and ERA-5 
#'reconstruction.
#'Specifically, for the monthly mean 2-meter temperature ("tas") variable, the
#'first 3 ensemble members, the first 5 forecast time steps from November 
#'initial month, year 2000 to 2005, the Iberian Peninsula region
#'(35N-45N, 10W-5E). 
#' 
#'The package "startR" is used to load the data from the data esarchive in the
#'Earth Sciences Department of Barcelona Supercomputing Center. 
#'
#'\preformatted{
#'
#'  # 1. Load libraries and define common variables
#'  library(startR)
#'  library(CSTools)
#'
#'  sdates <- sapply(2000:2005, function(x) paste0(x, '1101'))
#'  lonmax <- 5
#'  lonmin <- -10
#'  latmax <- 45
#'  latmin <- 35
#'
#'  # 2. Load exp
#'
#'  repos_exp <- paste0('/esarchive/exp/ecmwf/system5c3s/monthly_mean/',
#'                      '$var$_f6h/$var$_$sdate$.nc')
#'
#'  exp <- Start(dat = repos_exp,
#'               var = 'tas',
#'               member = indices(1:3),
#'               sdate = sdates,
#'               time = indices(1:5),
#'               lat = values(list(latmin, latmax)),
#'               lat_reorder = Sort(decreasing = FALSE), 
#'               lon = values(list(lonmin, lonmax)),
#'               lon_reorder = CircularSort(-180, 180),
#'               synonims = list(lon = c('lon', 'longitude'),
#'                               lat = c('lat', 'latitude'),
#'                               member = c('member', 'ensemble')),
#'               return_vars = list(lat = NULL, lon = NULL, time = 'sdate'),
#'               retrieve = TRUE)
#'
#'
#'  # 3. Load obs
#'
#'  exp_time <- attr(exp, "Variables")$common$time
#'  obs_date <- array(format(exp_time, "%Y%m"), dim = dim(exp_time))
#'
#'  path_obs <- '/esarchive/recon/ecmwf/era5/monthly_mean/$var$_f1h-r1440x721cds/$var$_$date$.nc'
#'  obs <- Start(dat = path_obs,
#'               var = 'tas',
#'               date = obs_date,
#'               split_multiselected_dims = TRUE,
#'               lat = values(list(latmin, latmax)),
#'               lat_reorder = Sort(decreasing = FALSE),
#'               lon = values(list(lonmin, lonmax)),
#'               lon_reorder = CircularSort(-180, 180),
#'               synonims = list(lon = c('lon', 'longitude'),
#'                               lat = c('lat', 'latitude')),
#'               transform = CDORemapper,
#'               transform_extra_cells = 2,
#'               transform_params = list(grid = 'r360x181',
#'                                       method = 'conservative'),
#'               transform_vars = c('lat', 'lon'),
#'               return_vars = list(lon = NULL, lat = NULL, time = 'date'),
#'               retrieve = TRUE)
#'
#'
#'  # 4. Check data
#'
#'  obs_time <- attr(obs,"Variables")$common$time
#'
#'  identical(format(obs_time, "%Y%m"), format(exp_time, "%Y%m"))
#'#[1] TRUE
#'  exp_lat <- attr(exp, "Variables")$common$lat
#'  exp_lon <- attr(exp, "Variables")$common$lon
#'  obs_lat <- attr(obs, "Variables")$common$lat
#'  obs_lon <- attr(obs, "Variables")$common$lon
#'
#'  all.equal(exp_lat, obs_lat, check.attributes = F)
#'#[1] TRUE
#'  all.equal(exp_lon, obs_lon, check.attributes = F)
#'#[1] TRUE
#'
#'
#' # 5. Combine into one object
#'
#'  map_temp <- list()
#'  map_temp$exp <- exp
#'  map_temp$obs <- obs
#'
#'}
#'@name map_temp
#'@docType data
NULL

#'Sample Of Experimental And Observational Climate Time Series Data 
#'
#'This sample data contain gridded seasonal forecast and corresponding 
#'observational data from ECMWF-System 5 forecast system and ERA-5 
#'reconstruction.
#'Specifically, for the monthly mean 2-meter temperature ("tas") variable, the
#'first 3 ensemble members, the first 5 forecast time steps from November 
#'initial month, year 2000 to 2005, spatial average of the Iberian Peninsula
#'region (35N-45N, 10W-5E). 
#' 
#'The package "startR" is used to load the data from the data esarchive in the
#'Earth Sciences Department of Barcelona Supercomputing Center 
#'(check \code{map_temp}). Caclulate the weighted area-mean by function 
#'\code{ClimProjDiags::WeightedMean}. 
#'
#'\preformatted{
#'
#'  # 1. Load data "map_temp" first and load libraries
#'
#'  library(ClimProjDiags)
#'
#'  map_temp <- esviz::map_temp
#'  attrs_exp <- attributes(map_temp$exp)[-1]
#'  attrs_obs <- attributes(map_temp$obs)[-1]
#' 
#'  # 2. Calculate weighted area mean
#'
#'  lats <- attr(map_temp$exp, "Variables")$common$lat
#'  lons <- attr(map_temp$exp, "Variables")$common$lon
#'
#'  ts_temp <- list()
#'  ts_temp$exp <- WeightedMean(map_temp$exp, lon = lons, lat = lats)
#'  ts_temp$obs <- WeightedMean(map_temp$obs, lon = lons, lat = lats)
#'
#'  attributes(ts_temp$exp) <- c(attributes(ts_temp$exp), attrs_exp)
#'  attributes(ts_temp$obs) <- c(attributes(ts_temp$obs), attrs_obs)
#'
#'}
#'
#'@name ts_temp
#'@docType data
NULL
