% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_nonsentinel_severity.R
\name{plot_nonsentinel_severity}
\alias{plot_nonsentinel_severity}
\title{Plot ERVISS non-sentinel severity data}
\usage{
plot_nonsentinel_severity(
  data,
  date_breaks = "1 month",
  date_format = "\%b \%Y"
)
}
\arguments{
\item{data}{A data.table or data.frame containing severity data, typically
output from \code{\link{get_nonsentinel_severity}}. Must contain columns:
date, value, pathogen, countryname.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 visualization of non-sentinel severity data, with facets
by country and colored by pathogen.
}
\examples{
\donttest{
data <- get_nonsentinel_severity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-06-30"),
  pathogen = "SARS-CoV-2",
  indicator = "hospitaladmissions"
)
plot_nonsentinel_severity(data, date_breaks = "1 month")
}
}
