#' Functions renamed in episensr 2.1.0
#'
#' @description
#' `r lifecycle::badge('deprecated')`
#'
#' episensr 2.1.0 renamed a number of functions to follow tidyverse conventions
#' or to simplify their names.
#'
#' * `boot.bias()` -> `boot_bias()`
#' * `confounders.array()` -> `confounders_array()`
#' * `confounders.emm()` -> `confounders_emm()`
#' * `confounders.evalue()` -> `confounders_evalue()`
#' * `confounders.ext()` -> `confounders_ext()`
#' * `confounders.limit()` -> `confounders_limit()`
#' * `confounders.poly()` -> `confounders_poly()`
#' * `misclassification()` -> `misclass()`
#' * `misclassification.cov()` -> `misclass_cov()`
#' * `probsens.conf()` -> `probsens_conf()`
#' * `probsens.irr()` -> `probsens_irr()`
#' * `probsens.irr.conf()` -> `probsens_irr_conf()`
#' * `probsens.sel()` -> `probsens_sel()`
#'
#' @keywords internal
#' @name rename
#' @aliases NULL
NULL

#' @rdname rename
#' @export
boot.bias <- function(bias_model, ...) {
  lifecycle::deprecate_warn("2.1.0", "boot.bias()", "boot_bias()")
  boot_bias(bias_model, ...)
}

#' @rdname rename
#' @export
confounders.array <- function(crude_risk, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.array()", "confounders_array()")
  confounders_array(crude_risk, ...)
}

#' @rdname rename
#' @export
confounders.emm <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.emm()", "confounders_emm()")
  confounders_emm(case, ...)
}

#' @rdname rename
#' @export
confounders.evalue <- function(est, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.evalue()", "confounders_evalue()")
  confounders_evalue(est, ...)
}

#' @rdname rename
#' @export
confounders.ext <- function(RR, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.ext()", "confounders_ext()")
  confounders_ext(RR, ...)
}

#' @rdname rename
#' @export
confounders.limit <- function(p, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.limit()", "confounders_limit()")
  confounders_limit(p, ...)
}

#' @rdname rename
#' @export
confounders.poly <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "confounders.poly()", "confounders_poly()")
  confounders_poly(case, ...)
}

#' @rdname rename
#' @export
misclassification <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "misclassification()", "misclass()")
  misclass(case, ...)
}

#' @rdname rename
#' @export
misclassification.cov <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "misclassification.cov()", "misclass_cov()")
  misclass_cov(case, ...)
}

#' @rdname rename
#' @export
probsens.conf <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "probsens.conf()", "probsens_conf()")
  probsens_conf(case, ...)
}

#' @rdname rename
#' @export
probsens.irr <- function(counts, ...) {
  lifecycle::deprecate_warn("2.1.0", "probsens.irr()", "probsens_irr()")
  probsens_irr(counts, ...)
}

#' @rdname rename
#' @export
probsens.irr.conf <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "probsens.irr.conf()", "probsens_irr_conf()")
  probsens_irr_conf(case, ...)
}

#' @rdname rename
#' @export
probsens.sel <- function(case, ...) {
  lifecycle::deprecate_warn("2.1.0", "probsens.sel()", "probsens_sel()")
  probsens_sel(case, ...)
}
